/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.MACAddress;
import apiipc.ipc.IPCEvent;

public abstract class VLANEvent
extends IPCEvent {
    public EventType type;

    public VLANEvent(IPCEventLTV iPCEventLTV) {
        super(iPCEventLTV);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        MAC_ENTRY_ADDED,
        MAC_ENTRY_REMOVED;

    }

    public static class MacEntryRemoved
    extends VLANEvent {
        public MACAddress mac;
        public String portName;
        public Boolean isDynamic;

        public MacEntryRemoved(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.MAC_ENTRY_REMOVED;
            this.mac = (MACAddress)iPCEventLTV.getEventParameters().get(0);
            this.portName = (String)iPCEventLTV.getEventParameters().get(1);
            this.isDynamic = (Boolean)iPCEventLTV.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tmac = " + this.mac + "\n\tportName = " + this.portName + "\n\tisDynamic = " + this.isDynamic;
        }
    }

    public static class MacEntryAdded
    extends VLANEvent {
        public MACAddress newMac;
        public String portName;
        public Boolean isDynamic;

        public MacEntryAdded(IPCEventLTV iPCEventLTV) {
            super(iPCEventLTV);
            this.type = EventType.MAC_ENTRY_ADDED;
            this.newMac = (MACAddress)iPCEventLTV.getEventParameters().get(0);
            this.portName = (String)iPCEventLTV.getEventParameters().get(1);
            this.isDynamic = (Boolean)iPCEventLTV.getEventParameters().get(2);
        }

        public String toString() {
            return super.toString() + "\n\tnewMac = " + this.newMac + "\n\tportName = " + this.portName + "\n\tisDynamic = " + this.isDynamic;
        }
    }
}

